/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *                                                                          *
 * FILE NAME:   IAI_EZMac_PIC.h                                             *
 *                                                                          *
 * DESIGNER:	Kovacs, Krisztian; Lukacs, Miklos                           *
 * PROGRAMMER: Kovacs Krisztian;                                            *
 *                                                                          *
 * DESCRIPTION: EZMac PIC processor dependend definitions                   *
 *                                                                          *
 * REVISION:    01_7  Nov  22, 2005     created by krk                      *
 *				01_7  Dec  08, 2005	Port to HiTech							*
 *                                                                          *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#ifndef EZmac_PIC
#define  EZmac_PIC


                /* ======================================= *
                 *         I N T R O D U C T I O N         *
                 * ======================================= */


                /* ======================================= *
                 *           P A R A M E T E R S           *
                 * ======================================= */


/*SPI port selection*/
//Note: the HW SPI port doesn't supported now!
#define SW_SPI
//#define HW_SPI

/****************************************************************************\
 If the ARSSI is used on the board, this definition has to be uncommented.
 ARSSI_value variable contains The ARSSI value for the last packet!
\****************************************************************************/
//#define EZMAC_BOARD_WITH_ADC


                /* ======================================= *
                 *          D E F I N I T I O N S          *
                 * ======================================= */

#ifdef HITECH_COMPILER
 #define int8 char
 #define int16 unsigned short
 #define int32 unsigned long
 #define uint8 unsigned char
 #define uint16 unsigned short
 #define uint32 unsigned long
 #define byte unsigned char
 #define BOOL bit

 #define FALSE 0
 #define TRUE 1

// Constants used in EXT_INT_EDGE() are:
 #define L_TO_H              0x40
 #define H_TO_L                 0
// Constants used in ENABLE/DISABLE_INTERRUPTS() are:
 #define GLOBAL
 #define INT_RTCC     0
 #define INT_RB       1
 #define INT_EXT      2
 #define INT_AD       3
 #define INT_TBE      4
 #define INT_RDA      5
 #define INT_TIMER1   6
 #define INT_TIMER2   7
 #define INT_CCP1     8
 #define INT_CCP2     9
 #define INT_SSP      10
 #define INT_BUSCOL   11
 #define INT_EEPROM   12
 #define INT_TIMER0   0
#endif

#ifdef HITECH_PIC18
   #include <pic18.h>

  #define PIN_A0  RA0
  #define PIN_A1  RA1
  #define PIN_A2  RA2
  #define PIN_A3  RA3
  #define PIN_A4  RA4
  #define PIN_A5  RA5

  #define PIN_B0  RB0
  #define PIN_B1  RB1
  #define PIN_B2  RB2
  #define PIN_B3  RB3
  #define PIN_B4  RB4
  #define PIN_B5  RB5
  #define PIN_B6  RB6
  #define PIN_B7  RB7

  #define PIN_C0  RC0
  #define PIN_C1  RC1
  #define PIN_C2  RC2
  #define PIN_C3  RC3
  #define PIN_C4  RC4
  #define PIN_C5  RC5
  #define PIN_C6  RC6
  #define PIN_C7  RC7

// Constants used for SETUP_TIMER_0() are:
  #define RTCC_INTERNAL   0
  #define RTCC_EXT_L_TO_H 32
  #define RTCC_EXT_H_TO_L 48

  #define RTCC_DIV_1      8
  #define RTCC_DIV_2      0
  #define RTCC_DIV_4      1
  #define RTCC_DIV_4      1
  #define RTCC_DIV_8      2
  #define RTCC_DIV_16     3
  #define RTCC_DIV_32     4
  #define RTCC_DIV_64     5
  #define RTCC_DIV_128    6
  #define RTCC_DIV_256    7

  #define RTCC_8_BIT      0     

// Constants used for WDT are:
  #define WDT_18MS        8   
  #define WDT_36MS        9   
  #define WDT_72MS       10   
  #define WDT_144MS      11   
  #define WDT_288MS      12   
  #define WDT_576MS      13   
  #define WDT_1152MS     14   
  #define WDT_2304MS     15   

// Constants used for SETUP_TIMER_1() are:
//      (or (via |) together constants from each group) 
  #define T1_DISABLED         0
  #define T1_INTERNAL         0x85
  #define T1_EXTERNAL         0x87
  #define T1_EXTERNAL_SYNC    0x83

  #define T1_CLK_OUT          8

  #define T1_DIV_BY_1         0
  #define T1_DIV_BY_2         0x10
  #define T1_DIV_BY_4         0x20
  #define T1_DIV_BY_8         0x30

// Constants used for SETUP_TIMER_2() are:
  #define T2_DISABLED         0
  #define T2_DIV_BY_1         4
  #define T2_DIV_BY_4         5
  #define T2_DIV_BY_16        6

// Constants used for SETUP_ADC() are:
  #define ADC_OFF                0          // ADC Off
  #define ADC_CLOCK_DIV_2     0x00
  #define ADC_CLOCK_DIV_8     0x01
  #define ADC_CLOCK_DIV_32    0x02
  #define ADC_CLOCK_INTERNAL  0x07          // Internal 2-6us

// Constants used in SETUP_ADC_PORTS() are:
  #define NO_ANALOGS                        0x0F    // None
  #define ALL_ANALOG                        0x00    // A0 A1 A2 A3 A5         
  #define AN0_AN1_AN2_AN4_VSS_VREF          0x1A    // A0 A1 A2 A5 VRefh=A3              
  #define AN0_AN1_AN3                       0X0C    // A0 A1 A3
  #define AN0_AN1_VSS_VREF                  0X1D    // A0 A1 VRefh=A3
  #define AN0_AN1_AN4_VREF_VREF             0x3A    // A0 A1 A5 VRefh=A3 VRefl=A2              
  #define AN0_AN1_VREF_VREF                 0x3D    // A0 A1 VRefh=A3 VRefl=A2
  #define AN0                               0x0E    // A0
  #define AN0_VREF_VREF                     0x3E    // A0 VRefh=A3 VRefl=A2
  #define ANALOG_RA3_REF         			0x10    //!old only provided for compatibility
  #define RA0_RA1_RA3_ANALOG    			0x0C    //!old only provided for compatibility
  #define RA0_RA1_ANALOG_RA3_REF 			0x1D    //!old only provided for compatibility
  #define ANALOG_RA3_RA2_REF              	0x30    //!old only provided for compatibility
  #define RA0_RA1_ANALOG_RA3_RA2_REF      	0x3D    //!old only provided for compatibility
  #define RA0_ANALOG                      	0x0E    //!old only provided for compatibility
  #define RA0_ANALOG_RA3_RA2_REF          	0x3E    //!old only provided for compatibility

// Constants used in READ_ADC() are:
  #define ADC_START_AND_READ     7   // This is the default if nothing is specified
  #define ADC_START_ONLY         1
  #define ADC_READ_ONLY          6

  #define enable_GLOBAL       GIE=1; PEIE=1
  #define enable_INT_RTCC     TMR0IE=1
  #define enable_INT_TIMER0   TMR0IE=1
  #define enable_INT_RB       RBIE=1
  #define enable_INT_EXT      INT0IE=1
  #define enable_INT_AD       ADIE=1
  #define enable_INT_TBE      TXIE=1
  #define enable_INT_RDA      RCIE=1
  #define enable_INT_TIMER1   TMR1IE=1
  #define enable_INT_TIMER2   TMR2IE=1
  #define enable_INT_CCP1     CCP1IE=1
  #define enable_INT_CCP2     CCP2IE=1
  #define enable_INT_SSP      SSPIE=1
  #define enable_INT_BUSCOL   BCLIE=1
  #define enable_INT_EEPROM   EEIE=1
 
  #define disable_GLOBAL       GIE=0; PEIE=0
  #define disable_INT_RTCC     TMR0IE=0
  #define disable_INT_TIMER0   TMR0IE=0
  #define disable_INT_RB       RBIE=0
  #define disable_INT_EXT      INT0IE=0
  #define disable_INT_AD       ADIE=0
  #define disable_INT_TBE      TXIE=0
  #define disable_INT_RDA      RCIE=0
  #define disable_INT_TIMER1   TMR1IE=0
  #define disable_INT_TIMER2   TMR2IE=0
  #define disable_INT_CCP1     CCP1IE=0
  #define disable_INT_CCP2     CCP2IE=0
  #define disable_INT_SSP      SSPIE=0
  #define disable_INT_BUSCOL   BCLIE=0
  #define disable_INT_EEPROM   EEIE=0
 
  #define clear_INT_RTCC     TMR0IF=0
  #define clear_INT_TIMER0   TMR0IF=0
  #define clear_INT_RB       RBIF=0
  #define clear_INT_EXT      INT0IF=0
  #define clear_INT_AD       ADIF=0
  #define clear_INT_TBE      TXIF=0
  #define clear_INT_RDA      RCIF=0
  #define clear_INT_TIMER1   TMR1IF=0
  #define clear_INT_TIMER2   TMR2IF=0
  #define clear_INT_CCP1     CCP1IF=0
  #define clear_INT_CCP2     CCP2IF=0
  #define clear_INT_SSP      SSPIF=0
  #define clear_INT_BUSCOL   BCLIF=0
  #define clear_INT_EEPROM   EEIF=0
 
  #define ext_int_edge_L_TO_H INTEDG0=1
  #define ext_int_edge_H_TO_L INTEDG0=0
 
  #define ext_int_edge(edge) ext_int_edge_##edge
  #define clear_interrupt(which) clear_##which
  #define enable_interrupts(which) enable_##which
  #define disable_interrupts(which) disable_##which
 
 /*port pins handling functions*/
  #define set_tris_A(value) TRISA=value
  #define set_tris_B(value) TRISB=value
  #define set_tris_C(value) TRISC=value
  #ifdef __PINS_40
   #define set_tris_D(value) TRISD=value
   #define set_tris_E(value) TRISE=value
  #endif
  #define output_low(pin) pin=0
  #define output_high(pin) pin=1
  #define input(pin) pin
 
// Constants used for SETUP_TIMER_0() are:
  #define RTCC_INTERNAL   0
  #define RTCC_EXT_L_TO_H 32
  #define RTCC_EXT_H_TO_L 48

  #define RTCC_DIV_1      8
  #define RTCC_DIV_2      0
  #define RTCC_DIV_4      1
  #define RTCC_DIV_4      1
  #define RTCC_DIV_8      2
  #define RTCC_DIV_16     3
  #define RTCC_DIV_32     4
  #define RTCC_DIV_64     5
  #define RTCC_DIV_128    6
  #define RTCC_DIV_256    7

  #define RTCC_8_BIT      0     

// Constants used for SETUP_TIMER_1() are:
//      (or (via |) together constants from each group) 
  #define T1_DISABLED         0
  #define T1_INTERNAL         0x85
  #define T1_EXTERNAL         0x87
  #define T1_EXTERNAL_SYNC    0x83

  #define T1_CLK_OUT          8

  #define T1_DIV_BY_1         0
  #define T1_DIV_BY_2         0x10
  #define T1_DIV_BY_4         0x20
  #define T1_DIV_BY_8         0x30

// Constants used for SETUP_TIMER_2() are:
  #define T2_DISABLED         0
  #define T2_DIV_BY_1         4
  #define T2_DIV_BY_4         5
  #define T2_DIV_BY_16        6

 /*handle the timers*/
  #define setup_timer_0(mode) T0CON=(T0CON&0x40)|0x80|mode     //8 bit timer
  #define setup_timer_1(mode) T1CON=mode     //16 bit timer
  #define setup_timer_2(mode, period, postscale) T2CON=(postscale<<3)|mode; PR2=period     //8 bit timer
 
  #define set_timer0(value) TMR0=(value)
  #define set_timer2(value) TMR2=(value)
  #define get_timer0() (TMR0)
  #define get_timer1() ((((int16)TMR1H)<<8)|((int16)TMR1L))
  #define get_timer2() (TMR2)
#endif

#ifdef HITECH_PIC16
  #include <pic.h>

  #define PIN_A0  RA0
  #define PIN_A1  RA1
  #define PIN_A2  RA2
  #define PIN_A3  RA3
  #define PIN_A4  RA4
  #define PIN_A5  RA5

  #define PIN_B0  RB0
  #define PIN_B1  RB1
  #define PIN_B2  RB2
  #define PIN_B3  RB3
  #define PIN_B4  RB4
  #define PIN_B5  RB5
  #define PIN_B6  RB6
  #define PIN_B7  RB7

  #define PIN_C0  RC0
  #define PIN_C1  RC1
  #define PIN_C2  RC2
  #define PIN_C3  RC3
  #define PIN_C4  RC4
  #define PIN_C5  RC5
  #define PIN_C6  RC6
  #define PIN_C7  RC7

// Constants used for SETUP_TIMER_0() are:
  #define RTCC_INTERNAL   0
  #define RTCC_EXT_L_TO_H 32
  #define RTCC_EXT_H_TO_L 48

  #define RTCC_DIV_1      8
  #define RTCC_DIV_2      0
  #define RTCC_DIV_4      1
  #define RTCC_DIV_4      1
  #define RTCC_DIV_8      2
  #define RTCC_DIV_16     3
  #define RTCC_DIV_32     4
  #define RTCC_DIV_64     5
  #define RTCC_DIV_128    6
  #define RTCC_DIV_256    7

  #define RTCC_8_BIT      0     

// Constants used for WDT are:
  #define WDT_18MS        8   
  #define WDT_36MS        9   
  #define WDT_72MS       10   
  #define WDT_144MS      11   
  #define WDT_288MS      12   
  #define WDT_576MS      13   
  #define WDT_1152MS     14   
  #define WDT_2304MS     15   

// Constants used for SETUP_TIMER_1() are:
//      (or (via |) together constants from each group) 
  #define T1_DISABLED         0
  #define T1_INTERNAL         0x85
  #define T1_EXTERNAL         0x87
  #define T1_EXTERNAL_SYNC    0x83

  #define T1_CLK_OUT          8

  #define T1_DIV_BY_1         0
  #define T1_DIV_BY_2         0x10
  #define T1_DIV_BY_4         0x20
  #define T1_DIV_BY_8         0x30

// Constants used for SETUP_TIMER_2() are:
  #define T2_DISABLED         0
  #define T2_DIV_BY_1         4
  #define T2_DIV_BY_4         5
  #define T2_DIV_BY_16        6

// Constants used for SETUP_ADC() are:
  #define ADC_OFF                0          // ADC Off
  #define ADC_CLOCK_DIV_2     0x00
  #define ADC_CLOCK_DIV_8     0x40
  #define ADC_CLOCK_DIV_32    0x80
  #define ADC_CLOCK_INTERNAL  0xc0          // Internal 2-6us

// Constants used in SETUP_ADC_PORTS() are:
  #define NO_ANALOGS                           7    // None
  #define ALL_ANALOG                           0    // A0 A1 A2 A3 A5         
  #define AN0_AN1_AN2_AN4_VSS_VREF             1    // A0 A1 A2 A5 VRefh=A3              
  #define AN0_AN1_AN3                          4    // A0 A1 A3
  #define AN0_AN1_VSS_VREF                     5    // A0 A1 VRefh=A3
  #define AN0_AN1_AN4_VREF_VREF             0x08    // A0 A1 A5 VRefh=A3 VRefl=A2              
  #define AN0_AN1_VREF_VREF                 0x0D    // A0 A1 VRefh=A3 VRefl=A2
  #define AN0                               0x0E    // A0
  #define AN0_VREF_VREF                     0x0F    // A0 VRefh=A3 VRefl=A2
  #define ANALOG_RA3_REF         			0x1         //!old only provided for compatibility
  #define RA0_RA1_RA3_ANALOG     			0x4         //!old only provided for compatibility
  #define RA0_RA1_ANALOG_RA3_REF 			0x5         //!old only provided for compatibility
  #define ANALOG_RA3_RA2_REF              	0x8   //!old only provided for compatibility
  #define RA0_RA1_ANALOG_RA3_RA2_REF      	0xD   //!old only provided for compatibility
  #define RA0_ANALOG                      	0xE   //!old only provided for compatibility
  #define RA0_ANALOG_RA3_RA2_REF          	0xF   //!old only provided for compatibility

// Constants used in READ_ADC() are:
  #define ADC_START_AND_READ     7   // This is the default if nothing is specified
  #define ADC_START_ONLY         1
  #define ADC_READ_ONLY          6

  #define enable_GLOBAL       GIE=1; PEIE=1
  #define enable_INT_RTCC     TMR0IE=1
  #define enable_INT_TIMER0   TMR0IE=1
  #define enable_INT_RB       RBIE=1
  #define enable_INT_EXT      INTE=1
  #define enable_INT_AD       ADIE=1
  #define enable_INT_TBE      TXIE=1
  #define enable_INT_RDA      RCIE=1
  #define enable_INT_TIMER1   TMR1IE=1
  #define enable_INT_TIMER2   TMR2IE=1
  #define enable_INT_CCP1     CCP1IE=1
  #define enable_INT_CCP2     CCP2IE=1
  #define enable_INT_SSP      SSPIE=1
  #define enable_INT_BUSCOL   BCLIE=1
  #define enable_INT_EEPROM   EEIE=1
 
  #define disable_GLOBAL       GIE=0; PEIE=0
  #define disable_INT_RTCC     TMR0IE=0
  #define disable_INT_TIMER0   TMR0IE=0
  #define disable_INT_RB       RBIE=0
  #define disable_INT_EXT      INTE=0
  #define disable_INT_AD       ADIE=0
  #define disable_INT_TBE      TXIE=0
  #define disable_INT_RDA      RCIE=0
  #define disable_INT_TIMER1   TMR1IE=0
  #define disable_INT_TIMER2   TMR2IE=0
  #define disable_INT_CCP1     CCP1IE=0
  #define disable_INT_CCP2     CCP2IE=0
  #define disable_INT_SSP      SSPIE=0
  #define disable_INT_BUSCOL   BCLIE=0
  #define disable_INT_EEPROM   EEIE=0
 
  #define clear_INT_RTCC     TMR0IF=0
  #define clear_INT_TIMER0   TMR0IF=0
  #define clear_INT_RB       RBIF=0
  #define clear_INT_EXT      INTF=0
  #define clear_INT_AD       ADIF=0
  #define clear_INT_TBE      TXIF=0
  #define clear_INT_RDA      RCIF=0
  #define clear_INT_TIMER1   TMR1IF=0
  #define clear_INT_TIMER2   TMR2IF=0
  #define clear_INT_CCP1     CCP1IF=0
  #define clear_INT_CCP2     CCP2IF=0
  #define clear_INT_SSP      SSPIF=0
  #define clear_INT_BUSCOL   BCLIF=0
  #define clear_INT_EEPROM   EEIF=0
 
  #define ext_int_edge_L_TO_H INTEDG=1
  #define ext_int_edge_H_TO_L INTEDG=0
 
  #define ext_int_edge(edge) ext_int_edge_##edge
  #define clear_interrupt(which) clear_##which
  #define enable_interrupts(which) enable_##which
  #define disable_interrupts(which) disable_##which
 
 /*port pins handling functions*/
  #define set_tris_A(value) TRISA=value
  #define set_tris_B(value) TRISB=value
  #define set_tris_C(value) TRISC=value
  #ifdef __PINS_40
   #define set_tris_D(value) TRISD=value
   #define set_tris_E(value) TRISE=value
  #endif
  #define output_low(pin) pin=0
  #define output_high(pin) pin=1
  #define input(pin) pin
 
 /*handle the timers*/
  #define setup_timer_0(mode) OPTION=(OPTION&0xC0)|mode     //8 bit timer
  #define setup_timer_1(mode) T1CON=mode     //16 bit timer
  #define setup_timer_2(mode, period, postscale) T2CON=(postscale<<3)|mode; PR2=period     //8 bit timer
  #define set_timer0(value) TMR0=(value)
  #define set_timer2(value) TMR2=(value)
  #define get_timer0() (TMR0)
  #define get_timer1() ((((int16)TMR1H)<<8)|((int16)TMR1L))
  #define get_timer2() (TMR2)
#endif

#ifdef HITECH_COMPILER
 #define BAUD 19200
 //#define BAUD 9600
// #define BAUD 2400
 #define DIVIDE ((int)(CLOCK_FREQ/(16UL * BAUD) -1))
#endif

                /* ======================================= *
                 *     T Y P E   D E C L A R A T I O N     *
                 * ======================================= */

typedef struct
{
unsigned int bit0 : 1;
unsigned int bit1 : 1;
unsigned int bit2 : 1;
unsigned int bit3 : 1;
unsigned int bit4 : 1;
unsigned int bit5 : 1;
unsigned int bit6 : 1;
unsigned int bit7 : 1;
} reg;

typedef union
{
   reg testreg;
   char adat;
}reg_union;


				/* ======================================= *
                 *            V A R I A B L E S            *
                 * ======================================= */

#ifdef HITECH_COMPILER
 #ifdef END_HARDWARE
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //                This is a sample I/O setting, it should be
  //              changed according to the application Hardware!!!
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

/*
   static volatile reg_union portb_reg @ 0x06;
  static volatile reg_union trisb_reg @ 0x86;
*/
  //settings for PIC18F2620	
  static volatile reg_union porta_reg @ 0xF80;
  static volatile reg_union portb_reg @ 0xF81;
  static volatile reg_union portc_reg @ 0xF82;
  static volatile reg_union bank1 trisa_reg @ 0xF92;
  static volatile reg_union bank1 trisb_reg @ 0xF93;
  static volatile reg_union bank1 trisc_reg @ 0xF94;

 #else                                               
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //              This is the debug I/O setting, can be
  //                       omitted if confusing!!!
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //settings for PIC16F876
  static volatile reg_union porta_reg @ 0x05;
  static volatile reg_union portb_reg @ 0x06;
  static volatile reg_union portc_reg @ 0x07;
  static volatile reg_union bank1 trisa_reg @ 0x85;
  static volatile reg_union bank1 trisb_reg @ 0x86;
 #endif                           
#endif



#ifdef CCS_C_COMPILER
 #ifdef END_HARDWARE
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //                This is a sample I/O setting, it should be
  //              changed according to the application Hardware!!!
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  reg_union portb_reg;
  reg_union trisb_reg;

  #pragma byte portb_reg=0x06
  #pragma byte trisb_reg=0x86


 #else                                               
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //              This is the debug I/O setting, can be
  //                       omitted if confusing!!!
  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
  //settings for PIC16F876
  reg_union porta_reg;
  reg_union portb_reg;
  reg_union portc_reg;
  reg_union trisa_reg;
  reg_union trisb_reg;

  #pragma byte porta_reg=0x05
  #pragma byte portb_reg=0x06
  #pragma byte portc_reg=0x07
  #pragma byte trisa_reg=0x85
  #pragma byte trisb_reg=0x86
 #endif                   
#endif

                /* ======================================= *
                 *        M I S C E L L A N E O U S        *
                 * ======================================= */
/* void */


                /* ======================================= *
                 *  F U N C T I O N   P R O T O T Y P E S  *
                 * ======================================= */



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  Spi_Comm0
  +
  + DESCRIPTION:    Read a single byte via the software SPI port. The outgoing
  +                 data is 0.
  +
  + RETURN:         The data from the SPI port.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int8 Spi_Comm0(void);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  Spi_Comm
  +
  + DESCRIPTION:    Write and read a command or register value via the software SPI port.
  +
  + RETURN:         The data from the SPI port.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int SPI_comm(int data);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  Spi_Comm
  +
  + DESCRIPTION:    Write a single byte via the software SPI port.
  +
  + RETURN:         none.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
// Changed by Laszlo Kadar on 26.11.05
void EZ_Spi_Write(int8 data);

#endif
